/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.Command;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AdbExePathCommand
extends Command {
    public AdbExePathCommand() {
        this.setLabel("ADB Executable Path");
        this.setTooltip("Sets the path to the Android Device Debugger (ADB) executable");
        this.setIcon("app");
    }

    @Override
    protected void doExecute(Application app) {
        JOptionPane.showMessageDialog(app.getAppFrame(), this.createPane(), "ADB Executable", 3);
    }

    @Override
    public JPanel createPane() {
        JPanel pane = new JPanel(new BorderLayout(0, 5));
        pane.setBorder(BorderFactory.createTitledBorder("Path to ADB Executable"));
        pane.add((Component)this.createInfoPane(), "Center");
        pane.add((Component)this.createPathPane(), "South");
        return pane;
    }

    private JPanel createPathPane() {
        final File adbExecutable = this.getApplication().getSettings().getAdbExecutable();
        final JTextField pathField = new JTextField(adbExecutable != null ? adbExecutable.getAbsolutePath() : "");
        JButton open = new JButton("...");
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AdbExePathCommand.this.createFileDialog(pathField, adbExecutable);
            }
        });
        JPanel pathPane = new JPanel(new BorderLayout(5, 0));
        pathPane.add((Component)pathField, "Center");
        pathPane.add((Component)open, "East");
        return pathPane;
    }

    private void createFileDialog(final JTextField txtField, File exe) {
        JFileChooser chooser = new JFileChooser(exe != null ? exe.getParentFile() : null);
        int rc = chooser.showOpenDialog(this.getApplication().getAppFrame());
        if (rc == 0) {
            final File file = chooser.getSelectedFile();
            this.getLog().info("chosen file: " + file.getAbsolutePath());
            if (file.canRead()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AdbExePathCommand.this.getLog().info("setting file: " + file.getAbsolutePath());
                        txtField.setText(file.getAbsolutePath());
                        AdbExePathCommand.this.getApplication().getSettings().setAdbExecutable(file);
                        AdbExePathCommand.this.getApplication().getDeviceManager().setAdbExecutable(file);
                        AdbExePathCommand.this.getApplication().getDeviceManager().createBridge();
                    }
                });
            } else {
                JOptionPane.showMessageDialog(this.getApplication().getAppFrame(), "Cannot read the file: " + file.getAbsolutePath(), "Not readable", 0);
            }
        }
    }

    private JLabel createInfoPane() {
        JLabel txt = new JLabel(this.loadResource("/adb-exe-info.html"));
        return txt;
    }
}

