/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.dev.AndroidDevice;
import com.ribomation.droidAtScreen.dev.AndroidDeviceListener;
import com.ribomation.droidAtScreen.gui.GuiUtil;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public abstract class Command
extends AbstractAction
implements AndroidDeviceListener {
    private Logger log = Logger.getLogger(this.getClass());
    private static Application application;
    private static Map<String, Command> cmds;
    private String name;
    private boolean enabledOnlyWithDevice = false;

    protected Command() {
        this.getApplication().addAndroidDeviceListener(this);
        this.name = this.extractName();
        cmds.put(this.getName(), this);
    }

    protected Command(String name) {
        this.getApplication().addAndroidDeviceListener(this);
        this.name = name;
        cmds.put(this.getName(), this);
    }

    public boolean isEnabledOnlyWithDevice() {
        return this.enabledOnlyWithDevice;
    }

    public void setEnabledOnlyWithDevice(boolean enabledOnlyWithDevice) {
        this.enabledOnlyWithDevice = enabledOnlyWithDevice;
    }

    @Override
    public void connected(AndroidDevice dev) {
    }

    @Override
    public void disconnected(AndroidDevice dev) {
    }

    protected abstract void doExecute(Application var1);

    public void execute() {
        try {
            this.doExecute(this.getApplication());
        }
        catch (Exception e) {
            this.getLog().error("Failed to execute command " + this.getName(), e);
            JOptionPane.showMessageDialog(null, "Failed to execute command " + this.getName() + ": " + e, "Application Error", 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public static <CmdType extends Command> CmdType find(Class<? extends Command> cmdCls) {
        String name = Command.extractName(cmdCls);
        return (CmdType)Command.get(name);
    }

    public static Command get(String name) {
        Command c = cmds.get(name.toLowerCase());
        if (c != null) {
            return c;
        }
        return Command.loadCommand(name);
    }

    protected static Map<String, Command> getCmds() {
        return cmds;
    }

    protected Logger getLog() {
        return this.log;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return (String)this.getValue("Name");
    }

    protected void setLabel(String label) {
        this.putValue("Name", label);
    }

    public String getTooltip() {
        return (String)this.getValue("ShortDescription");
    }

    protected void setTooltip(String label) {
        this.putValue("ShortDescription", label);
    }

    public Icon getIcon() {
        return (Icon)this.getValue("SmallIcon");
    }

    protected void setIcon(Icon ico) {
        this.putValue("SmallIcon", ico);
        this.putValue("SwingLargeIconKey", ico);
    }

    protected void setIcon(String icoName) {
        this.setIcon(GuiUtil.loadIcon(icoName));
    }

    public String getAccelerator() {
        return (String)this.getValue("AcceleratorKey");
    }

    protected void setAccelerator(String key) {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(key));
    }

    public int getMnemonic() {
        return (Integer)this.getValue("MnemonicKey");
    }

    protected void setMnemonic(char ch) {
        this.putValue("MnemonicKey", new Integer(ch));
    }

    public JMenuItem createMenuItem() {
        JMenuItem mi = this.newMenuItem();
        mi.setAction(this);
        return mi;
    }

    protected JMenuItem newMenuItem() {
        return new JMenuItem();
    }

    public AbstractButton createButton() {
        AbstractButton b = this.newButton();
        b.setAction(this);
        return b;
    }

    protected AbstractButton newButton() {
        JButton b = new JButton();
        b.setVerticalTextPosition(3);
        b.setHorizontalTextPosition(0);
        return b;
    }

    public JPanel createPane() {
        JPanel p = new JPanel();
        p.add(new JLabel("Empty/Dummy Pane"));
        return p;
    }

    protected Application getApplication() {
        if (application == null) {
            throw new IllegalStateException("Missing application ref. Must invoke Command.setApplication(...) before use.");
        }
        return application;
    }

    public static void setApplication(Application application) {
        Command.application = application;
    }

    protected static Command loadCommand(String name) {
        String clsName = Command.class.getPackage().getName() + "." + Command.toTitleCase(name) + "Command";
        try {
            Class<?> cls = Class.forName(clsName);
            return (Command)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            return new DummyCommand(name);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to create command " + name + ". ErrMsg=" + e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Not permitted to create command " + name + ". ErrMsg=" + e);
        }
    }

    private String extractName() {
        return Command.extractName(this.getClass());
    }

    private static String extractName(Class cls) {
        return Command.extractName(cls.getSimpleName());
    }

    private static String extractName(String clsName) {
        if (Command.isBlank(clsName)) {
            return "[NONE]";
        }
        return clsName.substring(0, clsName.lastIndexOf("Command")).toLowerCase();
    }

    private static String toTitleCase(String s) {
        if (Command.isBlank(s) || s.length() == 1) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected String loadResource(String path) {
        InputStream is = this.getClass().getResourceAsStream(path);
        if (is == null) {
            throw new RuntimeException("Failed to load text resource: " + path);
        }
        try {
            String line;
            StringBuilder buf = new StringBuilder(1000);
            BufferedReader in = new BufferedReader(new InputStreamReader(is));
            while ((line = in.readLine()) != null) {
                buf.append(line);
            }
            in.close();
            return buf.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load text resource: " + path, e);
        }
    }

    static {
        cmds = new HashMap<String, Command>();
    }

    protected static class DummyCommand
    extends Command {
        public DummyCommand(String name) {
            super("dummy-" + name);
            this.setLabel(name);
        }

        @Override
        protected void doExecute(Application app) {
            JOptionPane.showMessageDialog(null, "Command not yet implemented: " + this.getLabel(), "Undefined command", 2);
        }
    }
}

