/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.Command;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ImageDirectoryCommand
extends Command {
    public ImageDirectoryCommand() {
        this.setLabel("Image Dir");
        this.setIcon("imgfolder");
        this.setMnemonic('D');
        this.updateView(this.getApplication().getSettings().getImageDirectory());
    }

    protected void updateView(File imageDirectory) {
        this.setTooltip(String.format("Directory when saving screen-shots (%s)", imageDirectory.getName()));
    }

    @Override
    protected void doExecute(Application app) {
        File imageDirectory = app.getSettings().getImageDirectory();
        JFileChooser chooser = new JFileChooser(imageDirectory);
        chooser.setFileSelectionMode(1);
        int rc = chooser.showSaveDialog(app.getAppFrame());
        if (rc != 0) {
            return;
        }
        imageDirectory = chooser.getSelectedFile();
        if (!imageDirectory.isAbsolute() || !imageDirectory.canWrite()) {
            JOptionPane.showMessageDialog(app.getAppFrame(), "Not a writable directory '" + imageDirectory + "'", "Invalid directory", 0);
            return;
        }
        app.getSettings().setImageDirectory(imageDirectory);
        this.updateView(imageDirectory);
    }
}

