/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.CommandWithTarget;
import com.ribomation.droidAtScreen.gui.DeviceFrame;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class PropertiesCommand
extends CommandWithTarget<DeviceFrame> {
    public PropertiesCommand(DeviceFrame target) {
        super(target);
        this.updateButton(target);
    }

    @Override
    protected void updateButton(DeviceFrame target) {
        this.setIcon("list");
        this.setTooltip("Shows all device properties");
    }

    @Override
    protected void doExecute(Application app, DeviceFrame target) {
        Map<String, String> properties = target.getDevice().getProperties();
        String toolTipText = "Click on a row to view the complete property value";
        PropertiesModel model = new PropertiesModel(properties);
        JTable tbl = new JTable(model){

            @Override
            public String getToolTipText(MouseEvent event) {
                return "Click on a row to view the complete property value";
            }
        };
        tbl.getTableHeader().setToolTipText("Click on a row to view the complete property value");
        tbl.setRowSelectionAllowed(true);
        tbl.getSelectionModel().addListSelectionListener(model);
        tbl.setAutoResizeMode(4);
        tbl.setShowHorizontalLines(true);
        tbl.setFillsViewportHeight(true);
        tbl.setPreferredScrollableViewportSize(new Dimension(400, 200));
        JScrollPane pane = new JScrollPane(tbl);
        JOptionPane.showMessageDialog(app.getAppFrame(), pane, "Device Properties", -1);
    }

    class PropertiesModel
    extends AbstractTableModel
    implements ListSelectionListener {
        private List<String> names = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();

        PropertiesModel(Map<String, String> properties) {
            for (String name : new TreeSet<String>(properties.keySet())) {
                this.names.add(name);
                this.values.add(properties.get(name));
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                return;
            }
            int row = lsm.getMinSelectionIndex();
            JTextArea txt = new JTextArea((String)this.getValueAt(row, 1));
            txt.setRows(6);
            txt.setColumns(36);
            txt.setLineWrap(true);
            txt.setWrapStyleWord(true);
            txt.setEditable(false);
            JOptionPane.showMessageDialog(PropertiesCommand.this.getApplication().getAppFrame(), txt, (String)this.getValueAt(row, 0), -1);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col == 0) {
                return this.names.get(row);
            }
            if (col == 1) {
                return this.values.get(row);
            }
            return null;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Name";
            }
            if (col == 1) {
                return "Value";
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.names.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            if (col == 0) {
                return String.class;
            }
            if (col == 1) {
                return String.class;
            }
            return Object.class;
        }
    }
}

