/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.Command;
import com.ribomation.droidAtScreen.gui.ApplicationFrame;
import javax.swing.JOptionPane;

public class QuitCommand
extends Command {
    public QuitCommand() {
        this.setLabel("Quit");
        this.setTooltip("Quits the application");
        this.setIcon("exit");
        this.setMnemonic('Q');
    }

    @Override
    protected void doExecute(Application app) {
        if (!app.getSettings().isAskBeforeQuit() || this.askUser(app)) {
            this.doQuit(app);
        }
    }

    private void doQuit(Application app) {
        ApplicationFrame f = app.getAppFrame();
        if (f != null) {
            f.dispose();
        }
        System.exit(0);
    }

    private boolean askUser(Application app) {
        int rc = JOptionPane.showConfirmDialog(app.getAppFrame(), "Do you really want to quit?", "Quit?", 2);
        return rc == 0;
    }
}

