/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.CommandWithTarget;
import com.ribomation.droidAtScreen.dev.ScreenImage;
import com.ribomation.droidAtScreen.gui.DeviceFrame;
import com.ribomation.droidAtScreen.gui.RecordingListener;
import com.ribomation.droidAtScreen.gui.StatusBar;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class RecordingCommand
extends CommandWithTarget<DeviceFrame>
implements RecordingListener,
Runnable {
    private AtomicInteger next = new AtomicInteger(0);
    private AtomicBoolean capturing = new AtomicBoolean(true);
    private BlockingQueue<ScreenImage> images;
    private File dir;
    private String format = "png";
    private Thread runner;
    private DeviceFrame device;

    public RecordingCommand(DeviceFrame deviceFrame) {
        super(deviceFrame);
        this.setIcon("record");
        this.setTooltip("Continuously record screen-shots and save them to a directory, for further processing.");
    }

    @Override
    protected void doExecute(Application app, DeviceFrame deviceFrame) {
        if (this.capturing.get() && this.runner != null) {
            this.capturing.set(false);
            this.runner.interrupt();
            return;
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(app.getSettings().getImageDirectory());
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle("Select target directory for the images");
        chooser.setApproveButtonText("Images Dir");
        chooser.setApproveButtonToolTipText("All screen-shots will go into this directory, sequentially numbered.");
        int rc = chooser.showOpenDialog(app.getAppFrame());
        if (rc != 0) {
            return;
        }
        this.dir = chooser.getSelectedFile();
        if (!this.dir.isAbsolute() || !this.dir.canWrite()) {
            JOptionPane.showMessageDialog(app.getAppFrame(), "Not a writable directory " + this.dir, "Invalid directory", 0);
            return;
        }
        this.images = new LinkedBlockingQueue<ScreenImage>(120);
        this.device = deviceFrame;
        this.device.setRecordingListener(this);
        this.capturing.set(true);
        this.runner = new Thread(this);
        this.runner.start();
        this.setIcon("recording");
    }

    @Override
    protected void updateButton(DeviceFrame deviceFrame) {
    }

    @Override
    public void record(ScreenImage image) {
        try {
            this.images.put(image.copy());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        StatusBar statusBar = this.getApplication().getAppFrame().getStatusBar();
        try {
            do {
                ScreenImage image = this.images.take();
                File file = this.nextName();
                ImageIO.write((RenderedImage)image.toBufferedImage(), this.format, file);
                this.getLog().info("Screenshot saved " + file);
                statusBar.message("Saved %s", file.getName());
            } while (this.capturing.get());
            this.device.setRecordingListener(null);
            this.capturing.set(false);
        }
        catch (InterruptedException ignore) {
            this.device.setRecordingListener(null);
            this.capturing.set(false);
            this.images.clear();
            this.runner = null;
            this.images = null;
            this.device = null;
            SwingUtilities.invokeLater(new Runnable(statusBar){
                final /* synthetic */ StatusBar val$statusBar;
                {
                    this.val$statusBar = statusBar;
                }

                @Override
                public void run() {
                    RecordingCommand.this.setIcon("record");
                    this.val$statusBar.message("Recording stopped. %d images saved.", RecordingCommand.this.next.get());
                }
            });
        }
        catch (IOException e) {
            this.getLog().warn("Failed to save image: " + e);
            this.device.setRecordingListener(null);
            this.capturing.set(false);
            {
                catch (Throwable throwable) {
                    this.device.setRecordingListener(null);
                    this.capturing.set(false);
                    this.images.clear();
                    this.runner = null;
                    this.images = null;
                    this.device = null;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
            }
            this.images.clear();
            this.runner = null;
            this.images = null;
            this.device = null;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
        this.images.clear();
        this.runner = null;
        this.images = null;
        this.device = null;
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    File nextName() {
        return new File(this.dir, String.format("droidAtScreen-%d.%s", this.next.incrementAndGet(), this.format));
    }
}

