/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.CommandWithTarget;
import com.ribomation.droidAtScreen.cmd.PreferredScaleCommand;
import com.ribomation.droidAtScreen.gui.DeviceFrame;
import javax.swing.JDialog;

public class ScaleCommand
extends CommandWithTarget<DeviceFrame> {
    public ScaleCommand(DeviceFrame deviceFrame) {
        super(deviceFrame);
        this.setIcon("scale");
        this.updateButton(deviceFrame);
    }

    @Override
    protected void doExecute(Application app, final DeviceFrame deviceFrame) {
        JDialog dlg = PreferredScaleCommand.createScaleDialog(app, deviceFrame.getScale(), new PreferredScaleCommand.OnScaleUpdatedListener(){

            @Override
            public void onScaleUpdated(int value) {
                ScaleCommand.this.updateButton(deviceFrame);
                deviceFrame.setScale(value);
                deviceFrame.pack();
                deviceFrame.invalidate();
                deviceFrame.validate();
                deviceFrame.repaint();
            }
        });
        dlg.setLocationRelativeTo(deviceFrame);
        dlg.setVisible(true);
    }

    @Override
    protected void updateButton(DeviceFrame deviceFrame) {
        this.setTooltip(String.format("Current scale (%d%%)", deviceFrame.getScale()));
    }
}

