/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.Settings;
import com.ribomation.droidAtScreen.cmd.CommandWithTarget;
import com.ribomation.droidAtScreen.dev.ScreenImage;
import com.ribomation.droidAtScreen.gui.DeviceFrame;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ScreenshotCommand
extends CommandWithTarget<DeviceFrame> {
    public ScreenshotCommand(DeviceFrame target) {
        super(target);
        this.setIcon("camera");
        this.setTooltip("Takes a screen-shot and saves it to a file");
    }

    @Override
    protected void doExecute(Application app, DeviceFrame device) {
        ScreenImage image = device.getLastScreenshot().copy();
        if (app.getSettings().isAskBeforeScreenshot()) {
            File file;
            JFileChooser chooser = this.createChooser(app.getSettings().getImageDirectory(), this.suggestFilename(app), app.getSettings().getImageFormats());
            if (chooser.showSaveDialog(app.getAppFrame()) == 0 && (!(file = chooser.getSelectedFile()).exists() || this.askOverwrite(app, file))) {
                SwingUtilities.invokeLater(new ImageSaver(app, file, image));
            }
        } else {
            SwingUtilities.invokeLater(new ImageSaver(app, this.suggestFilename(app), image));
        }
    }

    @Override
    protected void updateButton(DeviceFrame target) {
    }

    private JFileChooser createChooser(File dir, File file, String[] exts) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(dir);
        chooser.setSelectedFile(file);
        chooser.setFileSelectionMode(0);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Image Files", exts));
        return chooser;
    }

    private File suggestFilename(Application app) {
        Settings cfg = app.getSettings();
        return new File(cfg.getImageDirectory(), String.format("%s-%d.%s", app.getInfo().getName().toLowerCase(), cfg.nextInt(), cfg.getImageFormat().toLowerCase()));
    }

    private boolean askOverwrite(Application app, File f) {
        return JOptionPane.showConfirmDialog(app.getAppFrame(), String.format("File '%s' already exists. Do you want to overwrite it?", f), "Overwrite?", 0) == 0;
    }

    private String extractExt(File f) {
        String n = f.getName();
        int dot = n.lastIndexOf(46);
        if (dot > 0) {
            return n.substring(dot + 1);
        }
        return n;
    }

    private String extractFormat(Application app, File f) {
        String[] formats = app.getSettings().getImageFormats();
        String ext = this.extractExt(f).toUpperCase();
        if (Arrays.asList(formats).contains(ext)) {
            return ext;
        }
        throw new RuntimeException("Invalid extension: " + f);
    }

    private class ImageSaver
    implements Runnable {
        private Application app;
        private File file;
        private ScreenImage image;

        private ImageSaver(Application app, File file, ScreenImage image) {
            this.app = app;
            this.file = file;
            this.image = image;
        }

        @Override
        public void run() {
            try {
                ImageIO.write((RenderedImage)this.image.toBufferedImage(), ScreenshotCommand.this.extractFormat(this.app, this.file), this.file);
                this.app.getAppFrame().getStatusBar().message("Written %s", this.file.getName());
                ScreenshotCommand.this.getLog().info(String.format("Screenshot file: %s", this.file.getAbsolutePath()));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.app.getAppFrame(), String.format("Failed to save '%s': %s", this.file, e.getMessage()), "Failure", 0);
            }
        }
    }
}

