/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.cmd;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.CommandWithTarget;
import com.ribomation.droidAtScreen.gui.DeviceFrame;

public class UpsideDownCommand
extends CommandWithTarget<DeviceFrame> {
    public UpsideDownCommand(DeviceFrame deviceFrame) {
        super(deviceFrame);
        this.updateButton(deviceFrame);
    }

    @Override
    protected void doExecute(Application app, DeviceFrame deviceFrame) {
        deviceFrame.setUpsideDown(!deviceFrame.isUpsideDown());
        this.updateButton(deviceFrame);
        deviceFrame.repaint();
    }

    @Override
    protected void updateButton(DeviceFrame deviceFrame) {
        this.setIcon(deviceFrame.isUpsideDown() ? "downsideup" : "upsidedown");
        this.setTooltip(String.format("Flips the image upside-down [%s]. (Useful for ZTE Blade devices)", deviceFrame.isUpsideDown() ? "UpsideDown" : "Normal"));
    }
}

