/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.dev;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import com.ribomation.droidAtScreen.dev.ScreenImage;
import java.io.IOException;
import java.util.Map;
import org.apache.log4j.Logger;

public class AndroidDevice
implements Comparable<AndroidDevice> {
    private final Logger log;
    private final IDevice target;
    private ConnectionState state = ConnectionState.offline;

    public AndroidDevice(IDevice target) {
        this.target = target;
        this.log = Logger.getLogger(AndroidDevice.class.getName() + ":" + target.getSerialNumber());
    }

    public IDevice getDevice() {
        return this.target;
    }

    public ScreenImage getScreenImage() {
        try {
            RawImage rawImage = this.target.getScreenshot();
            if (rawImage == null) {
                return null;
            }
            this.setState(this.target.getState());
            return new ScreenImage(rawImage);
        }
        catch (IOException e) {
            this.setState(ConnectionState.error);
            this.log.error("Failed to get screenshot: " + e);
        }
        catch (TimeoutException e) {
            this.setState(ConnectionState.timeout);
            this.log.warn("Got timeout");
        }
        catch (AdbCommandRejectedException e) {
            this.setState(ConnectionState.rejected);
            this.log.error("ADB command rejected: OFFLINE=" + e.isDeviceOffline());
        }
        return null;
    }

    public ConnectionState getState() {
        return this.state;
    }

    private void setState(ConnectionState s) {
        this.state = s;
    }

    private void setState(IDevice.DeviceState s) {
        switch (s) {
            case BOOTLOADER: {
                this.setState(ConnectionState.booting);
                break;
            }
            case OFFLINE: {
                this.setState(ConnectionState.offline);
                break;
            }
            case ONLINE: {
                this.setState(ConnectionState.online);
                break;
            }
            case RECOVERY: {
                this.setState(ConnectionState.recovery);
            }
        }
    }

    public String getName() {
        String name = this.isEmulator() ? this.target.getAvdName() : this.target.getProperty("ro.product.model");
        return name != null ? name : this.target.getSerialNumber();
    }

    public Map<String, String> getProperties() {
        return this.target.getProperties();
    }

    public boolean isEmulator() {
        return this.target.isEmulator();
    }

    public String toString() {
        return this.getName() + " (" + (this.isEmulator() ? "emulator" : "device") + ")";
    }

    public boolean equals(Object obj) {
        System.out.printf("AndroidDevice.equals: %s == %s%n", this, obj);
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AndroidDevice)) {
            return false;
        }
        AndroidDevice that = (AndroidDevice)obj;
        return this.getDevice().getSerialNumber().equals(that.getDevice().getSerialNumber());
    }

    public int hashCode() {
        return this.getDevice().getSerialNumber().hashCode();
    }

    @Override
    public int compareTo(AndroidDevice that) {
        return this.getDevice().getSerialNumber().compareTo(that.getDevice().getSerialNumber());
    }

    public static enum ConnectionState {
        booting,
        offline,
        online,
        recovery,
        timeout,
        rejected,
        error;

    }
}

