/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.dev;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.dev.AndroidDevice;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;

public class AndroidDeviceManager
extends Thread
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener {
    private Logger log = Logger.getLogger(this.getClass());
    private File adbExecutable;
    private Application app;

    public AndroidDeviceManager(Application app) {
        this.app = app;
    }

    public void initManager() {
        AndroidDebugBridge.init(false);
        Runtime.getRuntime().addShutdownHook(this);
        AndroidDebugBridge.addDebugBridgeChangeListener(this);
        AndroidDebugBridge.addDeviceChangeListener(this);
    }

    @Override
    public void run() {
        try {
            AndroidDebugBridge.disconnectBridge();
            AndroidDebugBridge.terminate();
        }
        catch (Exception e) {
            System.err.println("Failed to shutdown Android Device Bridge " + e);
        }
    }

    public void setAdbExecutable(File adbExecutable) {
        if (!adbExecutable.isFile()) {
            throw new RuntimeException("ADB executable '" + adbExecutable + "' is not a file");
        }
        if (!adbExecutable.canExecute()) {
            throw new RuntimeException("ADB executable '" + adbExecutable + "' is not executable.");
        }
        this.adbExecutable = adbExecutable;
    }

    public File getAdbExecutable() {
        return this.adbExecutable;
    }

    public void createBridge() {
        if (this.getAdbExecutable() == null) {
            throw new IllegalArgumentException("Need to set the ADB exe path first, before starting the bridge.");
        }
        try {
            AndroidDebugBridge.createBridge(this.getAdbExecutable().getCanonicalPath(), true);
            this.log.info("Connected to ADB via " + this.getSocketAddress());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to created the absolute path to the ADB executable: " + this.getAdbExecutable());
        }
    }

    @Override
    public void deviceConnected(IDevice dev) {
        this.log.info("Device connected: " + dev);
        this.app.connected(new AndroidDevice(dev));
    }

    @Override
    public void deviceDisconnected(IDevice dev) {
        this.log.info("Device disconnected: " + dev);
        this.app.disconnected(new AndroidDevice(dev));
    }

    public void reloadDevices() {
        for (IDevice dev : AndroidDebugBridge.getBridge().getDevices()) {
            this.deviceConnected(dev);
        }
    }

    public boolean restartADB() {
        return AndroidDebugBridge.getBridge().restart();
    }

    public boolean isConnectedToADB() {
        return AndroidDebugBridge.getBridge().isConnected();
    }

    public InetSocketAddress getSocketAddress() {
        return AndroidDebugBridge.getSocketAddress();
    }

    @Override
    public void deviceChanged(IDevice dev, int changeMask) {
        this.log.debug("Device changed: " + dev + ", mask=" + this.toMaskString(changeMask));
    }

    @Override
    public void bridgeChanged(AndroidDebugBridge adb) {
        this.log.info("ADB changed");
    }

    private String toMaskString(int mask) {
        StringBuilder result = new StringBuilder("");
        if ((mask & 4) != 0) {
            result.append("CHANGE_BUILD_INFO ");
        }
        if ((mask & 2) != 0) {
            result.append("CHANGE_CLIENT_LIST ");
        }
        if ((mask & 1) != 0) {
            result.append("CHANGE_STATE ");
        }
        return result.toString();
    }
}

