/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.dev;

import com.android.ddmlib.RawImage;
import java.awt.image.BufferedImage;

public class ScreenImage {
    private RawImage rawImage;

    public ScreenImage(RawImage rawImage) {
        this.rawImage = rawImage;
    }

    public RawImage getRawImage() {
        return this.rawImage;
    }

    public BufferedImage toBufferedImage() {
        int W = this.rawImage.width;
        int H = this.rawImage.height;
        BufferedImage image = new BufferedImage(W, H, 1);
        int bytesPerPixels = this.rawImage.bpp >> 3;
        int pxIdx = 0;
        for (int y = 0; y < H; ++y) {
            int x = 0;
            while (x < W) {
                image.setRGB(x, y, this.rawImage.getARGB(pxIdx));
                ++x;
                pxIdx += bytesPerPixels;
            }
        }
        return image;
    }

    public ScreenImage rotate() {
        this.rawImage = this.rawImage.getRotated();
        return this;
    }

    public ScreenImage copy() {
        ScreenImage copy = new ScreenImage(new RawImage());
        copy.rawImage.version = this.rawImage.version;
        copy.rawImage.bpp = this.rawImage.bpp;
        copy.rawImage.size = this.rawImage.size;
        copy.rawImage.width = this.rawImage.width;
        copy.rawImage.height = this.rawImage.height;
        copy.rawImage.red_offset = this.rawImage.red_offset;
        copy.rawImage.red_length = this.rawImage.red_length;
        copy.rawImage.blue_offset = this.rawImage.blue_offset;
        copy.rawImage.blue_length = this.rawImage.blue_length;
        copy.rawImage.green_offset = this.rawImage.green_offset;
        copy.rawImage.green_length = this.rawImage.green_length;
        copy.rawImage.alpha_offset = this.rawImage.alpha_offset;
        copy.rawImage.alpha_length = this.rawImage.alpha_length;
        copy.rawImage.data = new byte[this.rawImage.data.length];
        System.arraycopy(this.rawImage.data, 0, copy.rawImage.data, 0, this.rawImage.data.length);
        return copy;
    }

    public String toString() {
        return String.format("RawImage[%dx%d, %d bytes, bits/px=%d]", this.rawImage.width, this.rawImage.height, this.rawImage.data.length, this.rawImage.bpp);
    }

    public int getWidth() {
        return this.rawImage.width;
    }

    public int getHeight() {
        return this.rawImage.height;
    }
}

