/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.gui;

import com.ribomation.droidAtScreen.Application;
import com.ribomation.droidAtScreen.cmd.Command;
import com.ribomation.droidAtScreen.cmd.QuitCommand;
import com.ribomation.droidAtScreen.gui.GuiUtil;
import com.ribomation.droidAtScreen.gui.StatusBar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.log4j.Logger;

public class ApplicationFrame
extends JFrame {
    private Logger log = Logger.getLogger(ApplicationFrame.class);
    private Application app;
    private StatusBar statusBar;
    private final String[] TOOLBAR = new String[]{"ImageDirectory", "-", "AdbRestart", "AdbReloadDevices", "-", "Help", "About", "-", "Quit"};
    private final String[] FILE_MENU = new String[]{"Quit"};
    private final String[] IMAGE_MENU = new String[]{"ImageDirectory", "ImageFormat", "AskBeforeScreenshot"};
    private final String[] ADB_MENU = new String[]{"AdbRestart", "AdbReloadDevices", "AdbExePath"};
    private final String[] OPTIONS_MENU = new String[]{"PreferredScale", "-", "HideEmulators", "AskBeforeQuit", "-", "LookAndFeel", "-", "RemoveProperties"};
    private final String[] HELP_MENU = new String[]{"Help", "-", "Home", "Mail", "-", "About"};

    public ApplicationFrame(Application app) throws HeadlessException {
        this.app = app;
    }

    public StatusBar getStatusBar() {
        return this.statusBar;
    }

    public void initGUI() {
        this.setIconImage(GuiUtil.loadIcon("device").getImage());
        this.setTitle(this.app.getInfo().getName() + ", Version " + this.app.getInfo().getVersion());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ((Command)Command.find(QuitCommand.class)).execute();
            }
        });
        this.setJMenuBar(this.createMenubar());
        this.add((Component)GuiUtil.createToolbar(this.TOOLBAR), "North");
        this.add((Component)this.createDevicesTable(), "Center");
        this.statusBar = new StatusBar(this.app);
        this.add((Component)this.statusBar, "South");
        this.pack();
        this.setLocationByPlatform(true);
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        mb.add(GuiUtil.createMenu("File", 'F', this.FILE_MENU));
        mb.add(GuiUtil.createMenu("Image", 'I', this.IMAGE_MENU));
        mb.add(GuiUtil.createMenu("ADB", 'A', this.ADB_MENU));
        mb.add(GuiUtil.createMenu("Options", 'O', this.OPTIONS_MENU));
        mb.add(GuiUtil.createMenu("Help", 'H', this.HELP_MENU));
        return mb;
    }

    private JComponent createDevicesTable() {
        JTable tbl = new JTable(this.app.getDeviceTableModel());
        tbl.setAutoResizeMode(4);
        tbl.setRowSelectionAllowed(true);
        tbl.setShowHorizontalLines(true);
        tbl.setFillsViewportHeight(true);
        tbl.setPreferredScrollableViewportSize(new Dimension(450, 150));
        JScrollPane pane = new JScrollPane(tbl);
        pane.setBorder(BorderFactory.createTitledBorder("Devices"));
        return pane;
    }
}

