/*
 * Decompiled with CFR 0.152.
 */
package com.ribomation.droidAtScreen.gui;

import com.ribomation.droidAtScreen.gui.DeviceFrame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public class DeviceTableModel
extends AbstractTableModel {
    private static final int NAME = 0;
    private static final int TYPE = 1;
    private static final int SERNO = 2;
    private static final int STATE = 3;
    private static final int SHOW = 4;
    private List<DeviceFrame> devices = new ArrayList<DeviceFrame>();
    private final Logger log = Logger.getLogger(this.getClass());

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.devices.size();
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Type";
            }
            case 2: {
                return "Serial No.";
            }
            case 3: {
                return "State";
            }
            case 4: {
                return "Visible";
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Boolean.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        DeviceFrame dev = this.devices.get(row);
        if (dev != null) {
            switch (col) {
                case 0: {
                    return dev.getDevice().getName();
                }
                case 1: {
                    return dev.getDevice().isEmulator() ? "EMU" : "DEV";
                }
                case 2: {
                    return dev.getDevice().getDevice().getSerialNumber();
                }
                case 3: {
                    return dev.getDevice().getState();
                }
                case 4: {
                    return dev.isVisible();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 4;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        this.log.debug(String.format("setValueAt [%d,%d] %s", row, col, value));
        DeviceFrame dev = this.devices.get(row);
        if (dev == null) {
            return;
        }
        if (col == 4) {
            boolean newValue = (Boolean)value;
            if (!dev.isVisible() && newValue) {
                dev.pack();
                dev.setVisible(true);
            }
            if (dev.isVisible() && !newValue) {
                dev.stopRetriever();
                dev.setVisible(false);
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    public void add(DeviceFrame dev) {
        this.devices.add(dev);
        Collections.sort(this.devices);
        this.fireTableDataChanged();
    }

    public void remove(DeviceFrame dev) {
        this.devices.remove(dev);
        this.fireTableDataChanged();
    }

    public void removeAll() {
        this.devices.clear();
        this.fireTableDataChanged();
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    public List<DeviceFrame> getDevices() {
        return this.devices;
    }

    public DeviceFrame getDevice(String name) {
        for (DeviceFrame device : this.devices) {
            if (!device.getName().equals(name)) continue;
            return device;
        }
        return null;
    }
}

